---
title: IRR Overview · Cloudflare BYOIP docs
description: The Internet Routing Registry (IRR) is a globally distributed
  database of routing information which contains announced routes and routing
  policies in a common format. Network operators use this information, as well
  as RPKI, to configure backbone routers.
lastUpdated: 2025-10-30T18:03:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/byoip/concepts/irr-entries/
  md: https://developers.cloudflare.com/byoip/concepts/irr-entries/index.md
---

The [Internet Routing Registry (IRR)](http://www.irr.net/index.html) is a globally distributed database of routing information which contains announced routes and routing policies in a common format. Network operators use this information, as well as [RPKI](https://developers.cloudflare.com/byoip/concepts/route-filtering-rpki/), to configure backbone routers.

The IRR consists of many individual [routing registries](http://www.irr.net/docs/list.html), and some are managed by regional entities - such as the American Registry for Internet Numbers (ARIN), the Regional Internet Registry for Europe, Middle East and Central Asia (RIPE), and so on. Each routing registry contains IRR entries that provide information about IP prefixes and the [autonomous systems](https://www.cloudflare.com/learning/network-layer/what-is-an-autonomous-system/) authorized to announce them.

To announce your subnet prefixes, Cloudflare requires accurate IRR entries for your prefixes and autonomous system numbers (ASNs).

When you configure network infrastructure for services such as [Magic Transit](https://developers.cloudflare.com/magic-transit/about/), or before onboarding your IP to Cloudflare, [verify your IRR entries](https://developers.cloudflare.com/byoip/concepts/irr-entries/best-practices/#verify-an-irr-entry).
