---
title: Active Directory (SAML) · Cloudflare One docs
description: Integrate Active Directory with Cloudflare One for secure identity management.
lastUpdated: 2025-10-30T21:17:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/adfs/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/adfs/index.md
---

Warning

Microsoft recommends migrating your Active Directory Federation Service (AD FS) SSO to Microsoft Entra ID. For more information, refer to [Microsoft Learn](https://learn.microsoft.com/windows-server/identity/ad-fs/ad-fs-overview).

To set up the Microsoft Entra ID IdP integration with Cloudflare One, refer to [Microsoft Entra ID](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/).

Active Directory is a directory service developed by Microsoft for Windows domain networks. It is included in most Windows Server operating systems as a set of processes and services. Active Directory integrates with Cloudflare Access using Security Assertion Markup Language (SAML).

## Before you start

To get started, you need:

* An Active Directory Domain Controller where all users have an email attribute.
* Generic SAML enabled for your Access Identity Provider (IdP).
* A Microsoft server running with Active Directory Federation Services (AD FS) installed. All screenshots in these instructions are for Server 2012R2. Similar steps will work for newer versions.
* A browser safe certificate for Active Directory Federation Services (AD FS).

Once you fulfill the requirements above, you are ready to begin. Installation and basic configuration of Active Directory Federation Services (AD FS) is outside the scope of this guide. A detailed guide can be found in a [Microsoft KB](https://docs.microsoft.com/en-us/previous-versions/dynamicscrm-2016/deployment-administrators-guide/gg188612\(v=crm.8\)).

Then to begin the connection between Cloudflare Access and AD FS create a Relying Party Trust in AD FS.

## Create a Relying Party Trust

Run the Add Relying Party Trust wizard to begin SAML AD integration with Cloudflare Access.

To create a Relying Party Trust:

1. In **Windows Server**, launch the **ADFS Management** tool.

2. Select the **Relying Party Trusts** folder.

3. On the **Actions** sidebar, select **Add Relying Party Trust**. The **Add Relying Party Trust Wizard** launches.

4. In the left menu, choose **Select Data Source**.

5. Select the **Enter data about the relying party manually** option.

6. Select **Next**.

7. Enter a **Display name**. We suggest you use a recognizable name. Include any information regarding this connection in the **Notes** field.

8. Select **Next**. The **Choose Profile** step displays.

9. Select the **AD FS profile** option.

10. Select **Next**. The **Configure Certificate** step displays.

11. Leave the **Certificate** options at their defaults.

12. Select **Next**. The **Configure URL** step displays.

13. Select the **Enable support for the SAML 2.0 WebSSO protocol** option.

14. In the **Relying party SAML 2.0 SSO service URL** field, enter the following URL:

    ```txt
    https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
    ```

    You can find your team name in [Cloudflare One](https://one.dash.cloudflare.com) under **Settings** > **Team name**.

15. Select **Next**. The **Configure Identifiers** step displays.

    ![Add relying party trust wizard with callback URL pasted into open form field](https://developers.cloudflare.com/_astro/adfs-7.BHM4h9Ct_Z4Nbuf.webp)

16. Paste your callback URL in the **Relying party trust identifier** field.

17. Select **Next**. In the **Configure Multi-factor Authentication Now?** step, you can configure multi-factor authentication.

18. Select **Next**. The **Choose Issuance Authorization Rules** step displays.

19. Select the **Permit all users to access this relying party** option.

20. Select **Next**. The **Ready to Add Trust** step displays.

21. Review your settings.

22. Select **Next**. Cloudflare now relies on AD FS for user-identity authorization.

The **Edit Claim Rules for CF Login** screen automatically displays.

## Create claim rules

Now create 2 Claim Rules so that AD FS can take information from Cloudflare and return it to create [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/).

If you closed the Add Relying Trust wizard, use Explorer to find the **Relying Party Trusts** folder, select the newly created RPT file, and select **Edit Claim Rules** in the **Action** sidebar.

To create Claim Rules:

1. In the **Edit Claim Rules for CF Login** window, select **Add Rule**. The **Choose Rule Type** step displays.

2. In the **Claim rule template** field, select **Send LDAP Attributes as Claims** from the drop-down list.

3. Select **Next**. The **Edit Rule — Send Email** step displays.

4. Enter a descriptive **Claim rule name**.

5. Select **Active Directory** from the **Attribute store** drop-down list.

6. Select **E-mail-Addresses** from the **LDAP Attribute** and **Outgoing Claim Type** drop-down lists.

AD FS groups

If you wish to use AD FS groups in your SAML claims, use `token-groups - unqualified names` instead of `is-member-of-DL`. Using `is-member-of-DL` will display the group in the form of LDAP paths, whereas `token-groups - unqualified names` will return only the group name.

1. Select **OK**. You return to the **Choose Rule Type** step.

2. Select **Transform an Incoming Claim** from the **Claim rule template** drop-down list to create the second rule.

3. Select **Next**. The **Edit - Create Transient Name Identifier** window displays.

4. Enter a descriptive **Claim rule name**.

5. Select **E-Mail Address** from the **Incoming claim type** drop-down list.

6. Select **Name ID** from the **Outgoing claim type** drop-down list.

7. Select **Transient Identifier** from the **Outgoing name ID format** drop-down list.

8. Ensure that the **Pass through all claim values** option is selected.

9. Select **OK**.

Both Claim Rules are now available to export to your Cloudflare Access account.

## Export the certificate

Now you'll configure Cloudflare to recognize AD FS by extracting the *token-signing certificate* from AD FS.

To export the certificate:

1. Within the AD FS management console, select the **Service** under AD FS and choose the **Certificates** folder which contains the certificate to export.

2. In the **Certificates** card, right-click on the entry under **Token-signing**, and select **View certificate**. The **Certificates** window displays.

   ![Certificates window with token-signing certificate selected](https://developers.cloudflare.com/_astro/adfs-16.Rob0iaqT_1wJQkA.webp)

3. Select the **Details** tab, and select the **Copy to File** option.

4. The **Certificate Export Wizard** displays.

5. Select **Next**. The **Export File Format** window displays.

6. Select the **Base-64 encoded X.509 (.CER)** option.

7. Select **Next**.

8. Enter a name for the file.

9. Select **Next**.

10. Select **Finish**.

    Note the file path for later.

## Configure AD FS to sign SAML responses

To ensure that AD FS signs the full response when communicating with Cloudflare, open your local **PowerShell** and enter the following command:

```bash
Set-ADFSRelyingPartyTrust -TargetName "Name of RPT Display Name" -SamlResponseSignature "MessageAndAssertion"
```

## Configure Cloudflare One

To enable Cloudflare One to accept the claims and assertions sent from AD FS, follow these steps:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Integrations** > **Identity providers**.

2. Under **Your identity providers**, select **Add new identity provider**.

3. Select **SAML**.

4. Enter an IdP **Name**.

5. Under **Single Sign On URL** enter:

   ```txt
   https://hostnameOfADFS/adfs/ls/
   ```

   This is the default location. You can find your federation service identifier in AD FS.

6. In the **IdP Entity ID or Issuer URL** field, enter your Cloudflare Zero Trust team domain and include this callback at the end of the path: `/cdn-cgi/access/callback`. For example:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

7. Under **Signing certificate**, paste the exported certificate.

   There can be no spaces or return characters in the text field.

8. Select **Save**.

To test that your connection is working, go to **Integrations** > **Identity providers** and select **Test** next to the identity provider you want to test.

## Download SP metadata (optional)

Some IdPs allow administrators to upload metadata files from their SP (service provider).

To get your Cloudflare metadata file:

1. Download your unique SAML metadata file at the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/saml-metadata
   ```

   In Cloudflare Access, you can find a link to this URL in the **Edit a SAML identity provider** dialog. The link returns a web page with your SAML SP data in XML format.

2. Save the file in XML format.

3. Upload the XML document to your **Active Directory** account.

## Example API Configuration

```json
{
  "config": {
    "issuer_url": "https://<your-team-name>.cloudflareaccess.com/",
    "sso_target_url": "https://adfs.example.com/adfs/ls/",
    "attributes": ["email"],
    "email_attribute_name": "",
    "sign_request": false,
    "idp_public_cert": "MIIDpDCCAoygAwIBAgIGAV2ka+55MA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEG\nA1UEC.....GF/Q2/MHadws97cZg\nuTnQyuOqPuHbnN83d/2l1NSYKCbHt24o"
  },
  "type": "saml",
  "name": "adfs saml example"
}
```
