---
title: Control domain access · Cloudflare Learning Paths
description: IP Access Rules specify an action based on the origin of your user
  across a single domain or all of the domains in your account.
lastUpdated: 2025-09-25T16:31:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/surge-readiness/security/control-domain-access/
  md: https://developers.cloudflare.com/learning-paths/surge-readiness/security/control-domain-access/index.md
---

[IP Access Rules](https://developers.cloudflare.com/waf/tools/ip-access-rules/) specify an action based on the origin of your user across a single domain or all of the domains in your account.

IP Access Rules can be applied based on:

* IPv4 address or range: Specified in CIDR notation as `/16` or `/24`
* IPv6 address or range: Specified in CIDR notation as `/32`, `/48`, `/64`
* ASN
* Country or the Tor network

Note

We recommend locking down your origin with an Access Control List (ACL) which only allows [Cloudflare IPs](http://www.cloudflare.com/ips).

Actions:

* Block: Ensures that an IP address will never be allowed to access your site.
* CAPTCHA Challenge: Rules will be shown a CAPTCHA before allowed access.
* Javascript Challenge: Rules will be shown a five second javascript confirmation.
* Allowlist: Ensures that an IP address will never be blocked from accessing your site. This supersedes any Cloudflare security profile.

Note

Challenge Passage timeout applies to IP reputation, IUAM mode and user IP Firewall (CAPTCHA or JS Challenge): [cf\_clearance cookie](https://developers.cloudflare.com/fundamentals/reference/policies-compliances/cloudflare-cookies/#additional-cookies-used-by-the-challenge-platform) is set with `Max-age=Challenge Passage`.
