---
title: Heartbeat · Cloudflare Magic WAN docs
description: Magic WAN Connector communicates periodically with Cloudflare via
  HTTPS. This is also known as a heartbeat, and lets Cloudflare know that the
  Magic WAN Connector in question is connected to the Internet and reachable.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/heartbeat/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/maintenance/heartbeat/index.md
---

Magic WAN Connector communicates periodically with Cloudflare via HTTPS. This is also known as a heartbeat, and lets Cloudflare know that the Magic WAN Connector in question is connected to the Internet and reachable.

The heartbeat calls are made to `api.cloudflare.com`. Each Magic WAN Connector has a heartbeat frequency of 10 seconds, independently of the number of WAN interfaces you have running on your device.

There are three symbols for the heartbeat signal that allow you to quickly check the status of Magic WAN Connector:

* **Blue `i`**: Magic WAN Connector is contacting Cloudflare as expected.
* **Yellow triangle**: Magic WAN Connector has not yet connected to Cloudflare.
* **Red triangle**: There is a potential problem with Magic WAN Connector.

### Access Magic WAN Connector's heartbeat

1. In the Cloudflare dashboard, go to the **Configuration** page.

[Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/magic-wan/configuration)

1. In the **Magic WAN Connector** tab, find your Magic WAN Connector, and place your cursor over the icon on the **Status** column to check the timestamp. The timestamp shows you the last time Magic WAN Connector successfully contacted Cloudflare.
