---
title: IP geolocation · Cloudflare Network settings docs
description: IP geolocation adds the CF-IPCountry header to all requests to your
  origin server.
lastUpdated: 2025-09-10T08:58:51.000Z
chatbotDeprioritize: false
tags: Geolocation
source_url:
  html: https://developers.cloudflare.com/network/ip-geolocation/
  md: https://developers.cloudflare.com/network/ip-geolocation/index.md
---

IP geolocation adds the [`CF-IPCountry` header](https://developers.cloudflare.com/fundamentals/reference/http-headers/#cf-ipcountry) to all requests to your origin server.

Cloudflare automatically updates its IP geolocation database multiple times per week.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |

## Add IP geolocation information

The recommended procedure to enable IP geolocation information is to [enable the **Add visitor location headers** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/reference/#add-visitor-location-headers). This Managed Transform adds HTTP request headers with location information for the visitor's IP address, such as city, country, continent, longitude, and latitude.

If you only want the request header for the visitor's country, you can enable **IP Geolocation**.

* Dashboard

  To enable **IP Geolocation** in the dashboard:

  1. Log in to your [Cloudflare account](https://dash.cloudflare.com) and go to a specific domain.
  2. Go to **Network**.
  3. For **IP Geolocation**, switch the toggle to **On**.

* API

  To enable **IP Geolocation** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `ip_geolocation` as the setting name in the URI path, and the `value` parameter set to `"on"`.

Note

In order to use this data, you will need to then retrieve it from the [`CF-IPCountry` header](https://developers.cloudflare.com/fundamentals/reference/http-headers/#cf-ipcountry).

***

## Report an incorrect IP location

If you find an IP address with a location that you believe is incorrect, fill in the [data correction form](https://www.cloudflare.com/lp/ip-corrections/) with the relevant IP address range(s) along with the correct information as applicable (country, state/province, city name, and ZIP code).

If the data is confirmed, Cloudflare will make the necessary changes, which should be reflected within 48 hours.
