---
title: Policies · Cloudflare Page Shield docs
description: Use Page Shield policies to define the resources (scripts) allowed
  on your applications.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/page-shield/policies/
  md: https://developers.cloudflare.com/page-shield/policies/index.md
---

Note

Only available to Enterprise customers with a paid add-on.

Policies define the resources allowed on your applications through Content Security Policy (CSP) directives. Policies can log violations and also enforce an allowlist of resources, effectively blocking resources not included in the policies.

In the [new security dashboard](https://developers.cloudflare.com/security/), policies are called content security rules, and they are one of the available types of [security rules](https://developers.cloudflare.com/security/rules/). Security rules perform security-related actions on incoming requests that match specified filters.

Create [allow policies](#policy-actions) to define a positive security model, also known as positive blocking. According to this model, you define what is allowed and reject everything else. Such an approach helps you reduce the attack surface for unwanted third-party scripts in your application.

A policy can control both client-side resources monitored by Cloudflare, such as scripts and their connections, and other types of resources. Refer to [Supported CSP directives](https://developers.cloudflare.com/page-shield/policies/csp-directives/) for details.

### Important remarks

Third-party service providers may require specific CSP directives. Refer to your provider's documentation for more information on the CSP directives you need to include in your policy.

## Policy actions

A policy — or content security rule — can perform one of the following actions:

* **Log**: Cloudflare will log any resources not covered by the policy, without blocking any resources. Use this action to validate a new policy before deploying it. Resources not covered by the policy will be reported as [policy violations](https://developers.cloudflare.com/page-shield/policies/violations/).
* **Allow**: Cloudflare will block any resources not explicitly allowed by the policy. Switch to the *Allow* action after validating a new policy with the *Log* action, so that your policy does not block essential application resources, which would affect your application's end users. Policies with the *Allow* action will log [policy violations](https://developers.cloudflare.com/page-shield/policies/violations/) for any blocked resources.

For details on the CSP directives Cloudflare creates for each type of policy action, refer to [How Page Shield works](https://developers.cloudflare.com/page-shield/how-it-works/#positive-security-model-using-policies). For more information on the CSP directives supported by policies, refer to [Supported CSP directives](https://developers.cloudflare.com/page-shield/policies/csp-directives/).

## Next steps

Refer to the following pages for instructions on creating a policy or content security rule:

* [Create a policy in the dashboard](https://developers.cloudflare.com/page-shield/policies/create-dashboard/)
* [Page Shield API: Create a policy](https://developers.cloudflare.com/page-shield/reference/page-shield-api/#create-a-policy)

Once you have configured one or more policies in a zone, you can filter alert notifications according to those policies. These alerts are called [scoped alerts](https://developers.cloudflare.com/page-shield/alerts/#scoped-alerts).
