---
title: Troubleshoot Snippets · Cloudflare Rules docs
description: This error occurs when a Snippet attempts to call fetch(request)
  more than once.
lastUpdated: 2025-11-11T11:19:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/snippets/errors/
  md: https://developers.cloudflare.com/rules/snippets/errors/index.md
---

## Error 1201: Snippet tried to continue to origin multiple times

This error occurs when a Snippet attempts to call `fetch(request)` more than once.

### Resolution

Ensure that your Snippet code only calls `fetch(request)` once. This method is used to send the modified request to the origin server, and it should be called only once per Snippet to avoid conflicts.

## Error 1202: Snippets exceeded subrequests limit

This error occurs when the number of subrequests exceeds [the limit](https://developers.cloudflare.com/rules/snippets/#availability) for your Cloudflare plan.

### Resolution

Review your Snippet to ensure your code is within the subrequest [limits](https://developers.cloudflare.com/rules/snippets/#availability) for your plan. Each subrequest counts against your limit, including any redirects within a subrequest chain.

## Snippets cannot be renamed

The name you define when creating a Snippet will be used as the Snippet ID and cannot be edited afterwards.

### Resolution

To change the name of your Snippet, create a new Snippet and delete the old one.
