---
title: http.request.jwt.claims.iat.sec.values · Cloudflare Ruleset Engine docs
description: The `iat` (issued at) claim identifies the time (number of seconds)
  at which the JWT was issued.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.jwt.claims.iat.sec.values/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.jwt.claims.iat.sec.values/index.md
---

# http.request.jwt.claims.iat.sec.values

`http.request.jwt.claims.iat.sec.values` Array\<Integer>

The `iat` (issued at) claim identifies the time (number of seconds) at which the JWT was issued.

For details, refer to the [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) in RFC 7519.

Requires a Cloudflare Enterprise plan with a paid add-on.

For more information on validating JSON Web Tokens, refer to [JSON Web Tokens Validation](https://developers.cloudflare.com/api-shield/security/jwt-validation/) in the API Shield documentation.

Categories:

* Request
* JWT validation
