---
title: Custom Origin Trust Store · Cloudflare SSL/TLS docs
description: Custom Origin Trust Store allows you to upload certificate
  authorities (CAs) that Cloudflare will use to authenticate connections to your
  origin server.
lastUpdated: 2025-10-28T14:13:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/origin-configuration/custom-origin-trust-store/
  md: https://developers.cloudflare.com/ssl/origin-configuration/custom-origin-trust-store/index.md
---

By default, Cloudflare's global network maintains [a list of publicly trusted certificate authorities](https://github.com/cloudflare/cfssl_trust). This means that when using [Full (strict) encryption mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/), Cloudflare will only trust origin server certificates issued by a CA included in this trust store.

Custom Origin Trust Store allows you to upload certificate authorities (CAs) that Cloudflare will use to authenticate connections to your origin server. Use this feature to override the default trust store with your preferred CA or CAs.



When a CA has been uploaded to Custom Origin Trust Store, Cloudflare will ignore all default publicly trusted CAs and exclusively use the CA or CAs that have been uploaded to authenticate the origin server.

## Availability

To get access to Custom Origin Trust Store, [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) must be enabled on the zone.

## How to

To manage origin trust stores in the dashboard, go to the [**Origin Server**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/origin) page and use the **Custom Origin Trust Store** card.

To manage origin trust stores using the API, refer to the [API commands](#api-commands).

## Limitations

With [Full (strict) encryption mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/) enabled, if your uploaded CA expires and no alternative CAs are valid within the trust store, Cloudflare will not be able to properly authenticate connections to the origin server.

## API commands

#### List Custom Origin Trust Store Details

* API documentation: [List Custom Origin Trust Store Details](https://developers.cloudflare.com/api/resources/acm/subresources/custom_trust_store/methods/list/)
* Method: `GET`
* Endpoint: `/zones/$ZONE_ID/acm/custom_trust_store`

#### Custom Origin Trust Store Details

* API documentation: [Custom Origin Trust Store Details](https://developers.cloudflare.com/api/resources/acm/subresources/custom_trust_store/methods/get/)

* Method: `GET`

* Endpoint: `/zones/$ZONE_ID/acm/custom_trust_store/$CUSTOM_ORIGIN_TRUST_STORE_ID`

  Note

  The `$CUSTOM_ORIGIN_TRUST_STORE_ID` can be found via the [List command](#list-custom-origin-trust-store-details).

#### Upload Custom Origin Trust Store

* API documentation: [Upload Custom Origin Trust Store](https://developers.cloudflare.com/api/resources/acm/subresources/custom_trust_store/methods/create/)
* Method: `POST`
* Endpoint: `/zones/$ZONE_ID/acm/custom_trust_store`

#### Delete Custom Origin Trust Store

* API documentation: [Delete Custom Origin Trust Store](https://developers.cloudflare.com/api/resources/acm/subresources/custom_trust_store/methods/delete/)

* Method: `DELETE`

* Endpoint: `/zones/$ZONE_ID/acm/custom_trust_store/$CUSTOM_ORIGIN_TRUST_STORE_ID`

  Note

  The `$CUSTOM_ORIGIN_TRUST_STORE_ID` can be found via the [List command](#list-custom-origin-trust-store-details).
