---
title: Anchor heading · Cloudflare Style Guide
description: "The AnchorHeading component defines headings. Specifically,
  AnchorHeading performs the following:"
lastUpdated: 2025-03-06T20:33:22.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/anchor-heading/
  md: https://developers.cloudflare.com/style-guide/components/anchor-heading/index.md
---

The `AnchorHeading` component defines headings. Specifically, `AnchorHeading` performs the following:

1. Generates URL fragments corresponding to headings.
2. Formats URL fragments into compatible syntax. For example, a `&` is replaced with a `-`.
3. Creates a button to copy the URL at each fragment.
4. Allows heading fragments to be defined separately from the text of the heading itself.

Markdown files (including partials) have this behavior by default, applied via rehype plugins. Therefore, the `AnchorHeading` component is usually only required when writing headings yourself inside components, or when working on non-markdown files.

To override the ID given to a heading within Markdown, add an MDX comment at the end of the line:

Note

The `AnchorHeading` component emulates the behavior of the [`rehype-slug`](https://github.com/rehypejs/rehype-slug) and the [`rehype-autolink-headings`](https://github.com/rehypejs/rehype-autolink-headings). It adds an `id` based on the output of [`github-slugger`](https://github.com/Flet/github-slugger/) to the heading, as well as adding a button to copy a link to that particular heading.
